#pragma once

#include "player/BufferState.hpp"
#include "playercore/MediaTime.hpp"
#include "playercore/Quality.hpp"
#include "playercore/Statistics.hpp"
#include <vector>

namespace twitch {
namespace abr {
class Filter {
public:
    Filter() = default;
    virtual ~Filter() = default;
    Filter(const Filter&) = delete;
    const Filter& operator=(const Filter&) = delete;

    class Context {
    public:
        virtual BufferState getBufferState() const = 0;
        virtual MediaTime getBufferDuration() const = 0;
        virtual MediaTime getMinBufferTarget() const = 0;
        virtual float getPlaybackRate() const = 0;
        virtual const Quality& getSelected() const = 0;
        virtual Quality getTarget(const std::vector<Quality>& qualities) const = 0;
        virtual bool isLive() const = 0;
        //virtual bool isLiveLowLatency() const = 0;
        virtual void filter(const Filter& filter, const Quality& quality) = 0;
    };

    virtual const std::string& getName() const = 0;
    virtual bool filter(const std::vector<Quality>& qualities, Filter::Context& context) = 0;
    virtual void onStatistics(const Statistics& statistics, const Quality& quality) = 0;
    virtual void onStreamChange() = 0;
};
}
}
