#include "MaxBufferFilter.hpp"

namespace twitch {
namespace abr {
std::string MaxBufferFilter::Name = "MaxBufferFilter";
const MediaTime MaxBuffer(20.0f);

bool MaxBufferFilter::filter(const std::vector<Quality>& qualities, Filter::Context& context)
{
    (void)qualities;
    // use playback rate to determine effective buffer duration
    MediaTime buffered = context.getBufferDuration() / context.getPlaybackRate();
    // if buffered over the threshold no need to continue filtering
    return buffered < MaxBuffer;
}
}
}
