#pragma once

#include "playercore/MediaTime.hpp"
#include <algorithm>
#include <cmath>
#include <numeric>
#include <vector>

namespace twitch {
/** Moving average over a fixed sample window */
template <typename T>
class MovingAverage {
public:
    MovingAverage(size_t windowSize)
        : m_samples(windowSize)
        , m_sampleIndex(0)
        , m_windowSize(windowSize)
    {
    }

    void add(T value)
    {
        m_samples[m_sampleIndex++ % m_samples.size()] = value;
    }

    T average() const
    {
        size_t size = samples();
        if (size > 0) {
            return std::accumulate(m_samples.begin(), m_samples.begin() + size, T()) / static_cast<int>(size);
        }
        return T();
    }

    void reset()
    {
        m_sampleIndex = 0;
    }

    size_t samples() const { return std::min(m_sampleIndex, m_samples.size()); }

private:
    std::vector<T> m_samples;
    size_t m_sampleIndex;
    size_t m_windowSize;
};
}
