#pragma once

#include <algorithm>
#include <array>
#include <cmath>
#include <numeric>
#include <vector>

namespace twitch {
/** Measures a percentile from series of weighted samples */
class WeightedPercentile {
public:
    explicit WeightedPercentile(double maxWeight);

    void add(double weight, double value);

    double percentile(double percentile);
    double median() { return percentile(0.5); } // median

    void reset();

private:
    struct Sample {
        int index = 0;
        double weight = 0;
        double value = 0;
    };
    enum class SortOrder {
        Unsorted,
        ByValue,
        ByIndex
    };

    void sort(SortOrder order);

    SortOrder m_order;
    const double m_maxWeight;
    double m_currentWeight;
    int m_index;
    std::vector<Sample> m_samples;
};
}
