#include "PercentileEstimator.hpp"
#include <cmath>

namespace twitch {
namespace abr {
PercentileEstimator::PercentileEstimator(int maxWeight)
    : m_percentile(maxWeight)
{
    reset();
}

void PercentileEstimator::sample(MediaTime time, size_t value)
{
    double seconds = time.seconds();
    m_bytes += value;
    m_seconds += seconds;
}

int PercentileEstimator::estimate()
{
    double bps = (m_bytes * 8) / m_seconds;
    m_percentile.add(std::sqrt(m_bytes), bps);
    m_bytes = 0;
    m_seconds = 0;

    double estimate = m_percentile.median();
    m_estimate = static_cast<int>(estimate);

    if (estimate == std::numeric_limits<int>::max() || estimate < 0) {
        reset(); // reset on any unexpected value
    }

    return m_estimate;
}

void PercentileEstimator::reset()
{
    m_percentile.reset();
    m_estimate = NoEstimate;
    m_bytes = 0;
    m_seconds = 0;
}
}
}
