#pragma once

#include "Estimator.hpp"
#include "Percentile.hpp"

namespace twitch {
namespace abr {
class PercentileEstimator : public Estimator {
public:
    explicit PercentileEstimator(int maxWeight = 2000);
    ~PercentileEstimator() override = default;
    void sample(MediaTime time, size_t value) override;
    int estimate() override;
    void reset();
    int getEstimate() const override { return m_estimate; }

private:
    size_t m_bytes;
    double m_seconds;
    int m_estimate;
    WeightedPercentile m_percentile;
};
}
}
