#include "RandomFilter.hpp"
#include "util/Random.hpp"

namespace twitch {
namespace abr {
std::string RandomFilter::Name = "RandomFilter";

bool RandomFilter::filter(const std::vector<Quality>& qualities, Filter::Context& context)
{
    if (!qualities.empty()) {
        int index = Random::integer(0, static_cast<int>(qualities.size()));
        const auto& target = qualities[index];
        // filter all but the target
        for (const auto& quality : qualities) {
            if (quality != target) {
                context.filter(*this, quality);
            }
        }
    }
    return false;
}
}
}
