#pragma once

#include "playercore/MediaTime.hpp"

namespace twitch {
namespace abr {
struct RequestMetric {
    /** The number of bytes downloaded for the segment */
    size_t bytes = 0;
    /** Timestamp of when the transfer request was made */
    MediaTime initiated;
    /** Timestamp of when the transfer started */
    MediaTime start;
    /** Timestamp of when the transfer ended */
    MediaTime end;
    /** Timestamp of when the transfer was last updated */
    MediaTime lastUpdate;
    /** duration of the media */
    MediaTime mediaDuration;
    /** bitrate of the media if known */
    int mediaBitrate = 0;

    /** @return duration of the transfer (if complete)  */
    MediaTime getDuration() const { return end - start; }

    /** @return time between the transfer start and transfer initiation.  */
    MediaTime getRequestLatency() const { return start - initiated; }
};
}
}
