#include "ResolutionFilter.hpp"
#include <limits>

namespace twitch {
namespace abr {
std::string ResolutionFilter::Name = "ResolutionFilter";
const int MaxPixelArea = std::numeric_limits<int>::max();

ResolutionFilter::ResolutionFilter()
    : m_maxPixelArea(MaxPixelArea)
{
}

bool ResolutionFilter::filter(const std::vector<Quality>& qualities, Filter::Context& context)
{
    const float AreaFactor = 1.1f;
    for (const auto& quality : qualities) {
        int pixelArea = quality.width * quality.height;
        if (pixelArea > m_maxPixelArea * AreaFactor) {
            context.filter(*this, quality);
        }
    }
    return true;
}

void ResolutionFilter::onStatistics(const Statistics& statistics, const Quality& quality)
{
    (void)statistics;
    (void)quality;
}

void ResolutionFilter::setMaxResolution(int width, int height)
{
    if (width < MaxPixelArea) {
        m_maxPixelArea = width * height;
    }
}
}
}
