#pragma once

#include "Filter.hpp"

namespace twitch {
namespace abr {
class ResolutionFilter : public Filter {
public:
    ResolutionFilter();

    static std::string Name;
    const std::string& getName() const override { return Name; }
    bool filter(const std::vector<Quality>& qualities, Filter::Context& context) override;
    void onStatistics(const Statistics& statistics, const Quality& quality) override;
    void onStreamChange() override {};

    void setMaxResolution(int width, int height);

private:
    int m_maxPixelArea;
};
}
}
