#pragma once

#include "MovingAverage.hpp"

namespace twitch {
/** Moving average with a fixed time interval */
template <typename T>
class TimedMovingAverage {
public:
    TimedMovingAverage(MediaTime interval = MediaTime(1.0), size_t samples = 3)
        : m_average(samples)
        , m_value()
        , m_interval(interval)
    {
    }

    void add(T value)
    {
        m_value += value;
    }

    bool elapsed(MediaTime elapsed)
    {
        m_elapsed += elapsed;
        if (m_elapsed >= m_interval) {
            m_average.add(m_value);
            m_value = T();
            m_elapsed = MediaTime::zero();
            return true;
        }

        return false;
    }

    T average() const { return m_average.average(); }

    void reset()
    {
        m_average.reset();
        m_elapsed = MediaTime::zero();
        m_value = T();
    }

private:
    MovingAverage<T> m_average;
    T m_value;
    MediaTime m_elapsed;
    MediaTime m_interval;
};
}
