#pragma once

#include "Filter.hpp"

namespace twitch {
namespace abr {
class ViewportFilter : public Filter {
public:
    ViewportFilter();

    static std::string Name;
    const std::string& getName() const override { return Name; }
    bool filter(const std::vector<Quality>& qualities, Filter::Context& context) override;
    void onStatistics(const Statistics& statistics, const Quality& quality) override;
    void onStreamChange() override {};

    void setViewportSize(int width, int height);
    void setViewportScale(float scale);

private:
    int m_pixelArea;
    float m_scale;
};
}
}
