#pragma once

namespace twitch {
enum class WeightedMethod {
    Linear,
    Exponential
};

template <typename T, WeightedMethod Method = WeightedMethod::Linear>
class WeightedAverage {
public:
    WeightedAverage() { reset(); }

    void reset()
    {
        m_sumWt = T(0);
        m_sum = T(0);
        m_totalWeight = T(0);
    }

    void add(T value, T weight)
    {
        bool exponential = WeightedMethod::Exponential == Method;
        if (exponential) {
            T wtt = (weight * weight);
            m_sum += value * wtt;
            m_sumWt += wtt;
        } else {
            m_sum += value * weight;
            m_sumWt += weight;
        }
        m_totalWeight += weight;
    }

    T getValue() { return m_sumWt > 0.0 ? T(m_sum / m_sumWt) : T(0); }

    double getWeight() { return m_totalWeight; }

private:
    T m_sumWt;
    T m_sum;
    T m_totalWeight;
};
}
