#include "AnalyticsEvent.hpp"

namespace twitch {
namespace analytics {
using Clock = std::chrono::system_clock;
AnalyticsEvent::AnalyticsEvent(Listener& listener)
    : m_listener(listener)
{
}

void AnalyticsEvent::onError(const Error& error)
{
    (void)error;
}

void AnalyticsEvent::onRecoverableError(const Error& error)
{
    (void)error;
}

void AnalyticsEvent::onQualityChanged(const Quality& quality)
{
    (void)quality;
}

void AnalyticsEvent::onRebuffering(MediaTime timestamp, const std::string& bufferSessionId, int bufferEmptyCount)
{
    (void)timestamp;
    (void)bufferSessionId;
    (void)bufferEmptyCount;
}

void AnalyticsEvent::onStateChanged(MediaTime timestamp, Player::State state)
{
    (void)timestamp;
    (void)state;
}

void AnalyticsEvent::onDurationChanged(MediaTime timestamp, MediaTime duration)
{
    (void)timestamp;
    (void)duration;
}

void AnalyticsEvent::onPlayerLoad(MediaTime timestamp, const std::string& path, bool keepPlaySession)
{
    (void)timestamp;
    (void)path;
    (void)keepPlaySession;
}

void AnalyticsEvent::onPlayerSeek(MediaTime origin, MediaTime dest)
{
    (void)origin;
    (void)dest;
}

void AnalyticsEvent::onPlaySession(const PlaySession& session, MediaTime timestamp)
{
    (void)timestamp;
    (void)session;
}
}
}
