#pragma once

#include "PlaySession.hpp"
#include "playercore/Player.hpp"

#include <json11.hpp>
#include <string>

namespace twitch {
namespace analytics {
/** AnalyticsEvent class helps a specific event track relevant Player events */
class AnalyticsEvent {
public:
    class Listener {
    public:
        virtual void onEventReady(const AnalyticsEvent& event, json11::Json::object& properties) = 0;
    };

    explicit AnalyticsEvent(Listener& listener);
    virtual ~AnalyticsEvent() = default;

    virtual const char* getName() const = 0;
    virtual void onError(const Error& error);
    virtual void onRecoverableError(const Error& error);
    virtual void onQualityChanged(const Quality& quality);
    virtual void onRebuffering(MediaTime timestamp, const std::string& bufferSessionId, int bufferEmptyCount);
    virtual void onStateChanged(MediaTime timestamp, Player::State state);
    virtual void onDurationChanged(MediaTime timestamp, MediaTime duration);
    virtual void onPlayerLoad(MediaTime timestamp, const std::string& path, bool keepPlaySession);
    virtual void onPlayerSeek(MediaTime origin, MediaTime dest);
    virtual void onPlaySession(const PlaySession& session, MediaTime timestamp);

    static constexpr const char* uuidFormat = "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x";

protected:
    Listener& m_listener;
};
}
}
