#include "AutoQualityChanged.hpp"

namespace twitch {
namespace analytics {
AutoQualityChanged::AutoQualityChanged(const Player& player, Listener& listener)
    : AnalyticsEvent(listener)
    , m_player(player)
{
}

void AutoQualityChanged::onQualityChanged(const Quality& quality)
{
    (void)quality;
    if (m_player.getAutoSwitchQuality()) {
        json11::Json::object properties;
        auto buffered = m_player.getBufferedPosition() - m_player.getPosition().milliseconds();
        properties["buffer_level"] = static_cast<int>(buffered.count());
        properties["estimated_bandwidth"] = m_player.getBandwidthEstimate() / 1000;
        properties["current_stream_format_bitrate"] = m_player.getQuality().bitrate;
        m_listener.onEventReady(*this, properties);
    }
}
}
}
