#include "BufferEmpty.hpp"

namespace twitch {
namespace analytics {

BufferEmpty::BufferEmpty(Listener& listener)
    : AnalyticsEvent(listener)
{
}

void BufferEmpty::onRebuffering(MediaTime timestamp, const std::string& bufferSessionId, int bufferEmptyCount)
{
    json11::Json::object properties;
    properties["time"] = timestamp.seconds();
    properties["buffer_session_id"] = bufferSessionId;
    properties["buffer_empty_count"] = bufferEmptyCount;
    m_listener.onEventReady(*this, properties);
}
}
}
