#include "AnalyticsEvent.hpp"
#include "player/cancellation.hpp"

namespace twitch {
namespace analytics {
class BufferNSeconds : public AnalyticsEvent {
public:
    BufferNSeconds(AnalyticsEvent::Listener& listener, std::shared_ptr<Scheduler> scheduler, MediaTime interval);
    ~BufferNSeconds() override;

    const char* getName() const override { return "buffer_2_seconds"; }
    void onRebuffering(MediaTime timestamp, const std::string& bufferSessionId, int bufferEmptyCount) override;
    void onStateChanged(MediaTime timestamp, Player::State state) override;
    void onPlayerSeek(MediaTime origin, MediaTime dest) override;

private:
    using Clock = std::chrono::system_clock;

    std::shared_ptr<Scheduler> m_scheduler;
    CancellableRef m_outstanding;
    const std::chrono::milliseconds m_interval;
};
}
}
