#include "BufferRefill.hpp"

namespace twitch {
namespace analytics {
BufferRefill::BufferRefill(Listener& listener)
    : AnalyticsEvent(listener)
    , m_bufferEmptyCount(0)
    , m_isRebuffering(false)
{
}

void BufferRefill::onRebuffering(MediaTime timestamp, const std::string& bufferSessionId, int bufferEmptyCount)
{
    m_isRebuffering = true;
    m_rebufferStart = timestamp;
    m_bufferSessionId = bufferSessionId;
    m_bufferEmptyCount = bufferEmptyCount;
}

void BufferRefill::onStateChanged(MediaTime timestamp, Player::State state)
{
    if (m_isRebuffering && state == Player::State::Playing) {
        json11::Json::object properties;
        properties["time"] = timestamp.seconds();
        properties["buffering_time"] = (timestamp - m_rebufferStart).seconds();
        properties["buffer_session_id"] = m_bufferSessionId;
        properties["buffer_empty_count"] = m_bufferEmptyCount;

        m_listener.onEventReady(*this, properties);
    }

    if (state != Player::State::Buffering) {
        m_isRebuffering = false;
    }
}
}
}
