#pragma once

#include "AnalyticsEvent.hpp"

namespace twitch {
namespace analytics {
class BufferRefill : public AnalyticsEvent {
public:
    explicit BufferRefill(Listener& listener);

    const char* getName() const override { return "buffer-refill"; }
    void onRebuffering(MediaTime timestamp, const std::string& bufferSessionId, int bufferEmptyCount) override;
    void onStateChanged(MediaTime timestamp, Player::State state) override;

private:
    MediaTime m_rebufferStart;
    std::string m_bufferSessionId;
    int m_bufferEmptyCount;
    bool m_isRebuffering;
};
}
}
