#pragma once

#include "AnalyticsEvent.hpp"
#include "player/VideoStatistics.hpp"

namespace twitch {
namespace analytics {
class MinuteWatched : public AnalyticsEvent {
public:
    MinuteWatched(Listener& listener, Player& player, std::shared_ptr<Scheduler> scheduler);
    ~MinuteWatched() override;

    const char* getName() const override;
    void onError(const Error& error) override;
    void onStateChanged(MediaTime timestamp, Player::State state) override;
    void onPlaySession(const PlaySession& session, MediaTime timestamp) override;

private:
    void onTimerComplete();
    void updateTransportHistory(json11::Json::object& properties);
    void pause();
    void onStatePlay();
    void start(MediaTime duration, MediaTime now);
    void stop();
    void resume(MediaTime now);
    void cancelTask();
    bool isWatchableState() const;

    using Clock = std::chrono::system_clock;
    Player& m_player;
    Player::State m_state;
    std::shared_ptr<Scheduler> m_scheduler;
    std::shared_ptr<Cancellable> m_task;
    MediaTime m_timerDuration;
    MediaTime m_timerStart;
    MediaTime m_initialOffset;
    int m_minutesLogged;
    VideoStatistics m_previousStatistics;
    MediaTime m_lastSegmentStartTime;
    bool m_isClip;
};
}
}
