#include "AnalyticsEvent.hpp"

namespace twitch {
namespace analytics {
class NSecondsWatched : public AnalyticsEvent {
public:
    NSecondsWatched(AnalyticsEvent::Listener& listener, std::shared_ptr<Scheduler> scheduler, std::vector<MediaTime>& watchTimes);
    ~NSecondsWatched() override;

    const char* getName() const override { return "n_second_play"; }
    void onError(const Error& error) override;
    void onStateChanged(MediaTime timestamp, Player::State state) override;
    void onPlayerLoad(MediaTime timestamp, const std::string& path, bool keepPlaySession) override;

private:
    void onTimerComplete(MediaTime interval);
    void stop();
    std::shared_ptr<Cancellable> start(MediaTime interval);

    std::shared_ptr<Scheduler> m_scheduler;
    std::vector<MediaTime> m_watchTimes;
    std::vector<std::shared_ptr<Cancellable>> m_tasks;
    bool m_watchStarted;
};
}
}
