#include "PlaySession.hpp"
#include "analytics/AnalyticsEvent.hpp"
#include "twitch/TwitchLink.hpp"
#include "util/Uuid.hpp"
#include <algorithm>

namespace twitch {
namespace analytics {
PlaySession::PlaySession(const std::string& path)
    : m_path(path)
    , m_type(ContentType::Unknown)
{
    m_sessionId = Uuid::random().toString(AnalyticsEvent::uuidFormat);

    auto link = TwitchLink::parse(path);
    m_id = link.first;
    m_type = link.second;

    // lvs streams will match usher url: api/lvs/hls/lvs.{customerId}.{contentId}
    std::string lvs("lvs.");
    auto position = path.find(lvs);
    if (position != std::string::npos) {
        std::string remaining = path.substr(position + lvs.length());
        // customer id part
        position = remaining.find_first_of('.');

        if (position != std::string::npos) {
            m_customerId = remaining.substr(0, position);
            // content id part
            remaining = remaining.substr(position + 1);
            position = remaining.find_first_of('.');

            if (position != std::string::npos) {
                m_contentId = remaining.substr(0, position);
            }
        }
    }
}

void PlaySession::addProperties(json11::Json::object& properties)
{
    if (hasContentType()) {
        properties["live"] = isLive();
    }

    if (!m_id.empty()) {
        switch (m_type) {
        case ContentType::Live:
            properties["channel_id"] = m_id;
            break;
        case ContentType::VOD:
            properties["vod_id"] = m_id;
            break;
        case ContentType::Clip:
            properties["clip_id"] = m_id;
            break;
        case ContentType::Unknown:
            break;
        }
    }

    properties["play_session_id"] = m_sessionId;

    if (!m_customerId.empty()) {
        properties["customer_id"] = m_customerId;
    }

    if (!m_contentId.empty()) {
        properties["content_id"] = m_contentId;
    }
}
}
}
