#pragma once

#include "twitch/TwitchLink.hpp"
#include <json11.hpp>
#include <string>

namespace twitch {
namespace analytics {
class PlaySession {
public:
    using ContentType = TwitchLink::ContentType;

    explicit PlaySession(const std::string& path);
    bool isLive() const { return m_type == ContentType::Live; }
    bool isClip() const { return m_type == ContentType::Clip; }
    void addProperties(json11::Json::object& properties);
    bool hasContentType() const { return m_type != ContentType::Unknown; }
    void setContentType(ContentType type) { m_type = type; }

private:
    std::string m_path;
    ContentType m_type;
    std::string m_id;
    std::string m_sessionId;
    std::string m_customerId;
    std::string m_contentId;
};
}
}
