#include "SpadeClient.hpp"
#include "debug/trace.hpp"
#include "util/Base64.hpp"

namespace twitch {
namespace analytics {
const std::string SpadeClient::EchoUrl("https://spade-echo.internal.justin.tv/track");
const std::string SpadeClient::DefaultUrl("https://spade.twitch.tv");

SpadeClient::SpadeClient(std::shared_ptr<HttpClient> client, const std::string& baseUrl)
    : m_client(std::move(client))
    , m_baseUrl(baseUrl)
{
}

void SpadeClient::send(const std::string& name, json11::Json::object& properties)
{
    json11::Json::object event;
    event["event"] = name;
    event["properties"] = properties;

    auto request = m_client->createRequest(m_baseUrl, HttpMethod::POST);
    request->setRequestMode("no-cors"); // Effective for web platform only
    request->setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");

    std::string B64EncodedEvent(Base64::encode(json11::Json(event).dump()));
    std::string contentString("data=" + B64EncodedEvent);
    std::vector<uint8_t> contentBytes(contentString.begin(), contentString.end());
    request->setContent(contentBytes);

    m_client->send(
        request, [](std::shared_ptr<HttpResponse> response) {
            // Can't access response because spade requests are opaque
            (void)response; },
        [](int error) {
            TRACE_ERROR("SpadeClient received error %d", error);
        });
}
}
}
