#pragma once

#include "playercore/platform/HttpClient.hpp"
#include <json11.hpp>
#include <memory>
#include <string>

namespace twitch {
namespace analytics {
/** Client used for sending events to Spade */
class SpadeClient {
public:
    static const std::string EchoUrl; // internal host for testing
    static const std::string DefaultUrl;

    /**
     * @param client used to make the HTTP requests
     * @param host the name of the Spade host to send the events to
     */
    SpadeClient(std::shared_ptr<HttpClient> client, const std::string& baseUrl);

    /**
     * Sends an event to the spade endpoint
     *
     * @param name event name
     * @param properties event properties
     */
    void send(const std::string& name, json11::Json::object& properties);

    /**
     * Sets the endpoint for spade client
     */
    void setAnalyticsEndpoint(const std::string& endpoint) { m_baseUrl = endpoint; }

private:
    std::shared_ptr<HttpClient> m_client;
    std::string m_baseUrl;
};
}
}
