#pragma once

#include "AnalyticsEvent.hpp"

namespace twitch {
namespace analytics {
class VideoError : public AnalyticsEvent {
public:
    explicit VideoError(Listener& listener);

    const char* getName() const override { return "video_error"; }
    void onError(const Error& error) override;
    void onRecoverableError(const Error& error) override;

private:
    void populateError(const Error& error, bool recoverable);
};
}
}
