#include "VideoPlay.hpp"

namespace twitch {
namespace analytics {
VideoPlay::VideoPlay(Listener& listener)
    : AnalyticsEvent(listener)
    , m_state(Player::State::Idle)
{
}

void VideoPlay::onPlayerLoad(MediaTime timestamp, const std::string&, bool keepPlaySession)
{
    if (!keepPlaySession) {
        m_loadTimestamp = timestamp;
    }
}

void VideoPlay::onStateChanged(MediaTime timestamp, Player::State state)
{
    m_state = state;

    if (state == Player::State::Playing && m_loadTimestamp > MediaTime::zero()) {
        json11::Json::object properties;
        properties["time"] = timestamp.seconds();
        properties["time_since_load_start"] = static_cast<int>((timestamp - m_loadTimestamp).milliseconds().count());
        m_listener.onEventReady(*this, properties);
        m_loadTimestamp = MediaTime::zero();
    }
}

void VideoPlay::onPlaySession(const PlaySession& session, MediaTime timestamp)
{
    (void)session;
    // playSession occurring while already playing, create a new session
    if (m_state == Player::State::Playing || m_state == Player::State::Buffering) {
        json11::Json::object properties;
        properties["time"] = timestamp.seconds();
        m_listener.onEventReady(*this, properties);
        m_loadTimestamp = MediaTime::zero();
    }
}

void VideoPlay::onDurationChanged(MediaTime timestamp, MediaTime duration)
{
    (void)timestamp;
    (void)duration;
}
}
}
