#pragma once

#include "AnalyticsEvent.hpp"

namespace twitch {
namespace analytics {
class VideoPlay : public AnalyticsEvent {
public:
    explicit VideoPlay(Listener& listener);

    const char* getName() const override { return "video-play"; }
    // Player::Listener events
    void onPlayerLoad(MediaTime timestamp, const std::string& path, bool keepPlaySession) override;
    void onPlaySession(const PlaySession& session, MediaTime timestamp) override;
    void onStateChanged(MediaTime timestamp, Player::State state) override;
    void onDurationChanged(MediaTime timestamp, MediaTime duration) override;

private:
    MediaTime m_loadTimestamp;
    Player::State m_state;
};
}
}
