#include "VideoSeekSuccess.hpp"
#include <cmath>

namespace twitch {
namespace analytics {

VideoSeekSuccess::VideoSeekSuccess(Listener& listener)
    : AnalyticsEvent(listener)
    , m_duration(MediaTime::zero())
    , m_pendingSeek(false)
{
}

void VideoSeekSuccess::onStateChanged(MediaTime timestamp, Player::State state)
{
    (void)timestamp;

    if (m_pendingSeek && state == Player::State::Playing) {
        json11::Json::object properties {
            { "timestamp_departed", m_seekOrigin.seconds() },
            { "timestamp_target", m_seekDestination.seconds() },
            { "time_spent_seeking", (MediaTime::now() - m_seekStart).seconds() },
            { "video_length", int(std::round(m_duration.seconds())) }
        };
        m_listener.onEventReady(*this, properties);
    }

    if (state != Player::State::Buffering) {
        m_pendingSeek = false;
    }
}

void VideoSeekSuccess::onDurationChanged(MediaTime timestamp, MediaTime duration)
{
    (void)timestamp;
    m_duration = duration;
}

void VideoSeekSuccess::onPlayerSeek(MediaTime origin, MediaTime dest)
{
    m_pendingSeek = true;
    m_seekStart = MediaTime::now();
    m_seekOrigin = origin;
    m_seekDestination = dest;
}
}
}
