#pragma once

#include "AnalyticsEvent.hpp"

namespace twitch {
namespace analytics {
class VideoSeekSuccess : public AnalyticsEvent {
public:
    explicit VideoSeekSuccess(Listener& listener);
    ~VideoSeekSuccess() override = default;

    const char* getName() const override { return "video_seek_success"; }
    void onStateChanged(MediaTime timestamp, Player::State state) override;
    void onDurationChanged(MediaTime timestamp, MediaTime duration) override;
    void onPlayerSeek(MediaTime origin, MediaTime dest) override;

private:
    MediaTime m_seekStart;
    MediaTime m_seekOrigin;
    MediaTime m_seekDestination;
    MediaTime m_duration;
    bool m_pendingSeek;
};
}
}
