#include "DebugPlayer.hpp"

namespace twitch {

static_assert(sizeof(DebugMediaPlayer) == sizeof(AsyncMediaPlayer), "DebugMediaPlayer must be same size as MediaPlayer since the class will be casted");
static_assert(std::is_base_of<AsyncMediaPlayer, DebugMediaPlayer>::value, "MediaPlayer must be the base of DebugMediaPlayer");

DebugMediaPlayer::DebugMediaPlayer(Player::Listener& listener, std::shared_ptr<twitch::NativePlatform> platform, MediaSource::Request::Listener* requestListener)
    : AsyncMediaPlayer(listener, platform, requestListener)
{
}

void DebugMediaPlayer::debugSimulatePlaybackComplete()
{
    seekTo(getDuration());
}

void DebugMediaPlayer::debugSimulateVideoError()
{
    triggerError(Error(ErrorSource::Source, MediaResult::Error, "Simulate Video Error"));
}
}
