#include "ExceptionHandler.hpp"
#include "trace.hpp"
#include <exception>

namespace twitch {
std::map<std::thread::id, std::string> ExceptionHandler::s_registeredThreads;

void ExceptionHandler::handleTerminate()
{
    auto threadId = std::this_thread::get_id();
    auto itr = s_registeredThreads.find(threadId);
    if (itr == s_registeredThreads.end()) {
        TRACE_ERROR("ExceptionHandler Received terminate() for thread id=0x%p", threadId);
    } else {
        TRACE_ERROR("ExceptionHandler Received terminate() for thread name='%s')", itr->second.c_str());
    }

#if PLAYERCORE_ENABLE_EXCEPTIONS
    auto exception = std::current_exception();
    if (exception) {
        try {
            std::rethrow_exception(exception);
        } catch (std::exception& e) {
            TRACE_ERROR("ExceptionHandler Current exception: %s", e.what());
        } catch (...) {
            TRACE_ERROR("ExceptionHandler Current exception unknown");
        }
    }
#endif
}

void ExceptionHandler::registerTerminateHandler(std::thread::id threadId, const std::string& name)
{
    s_registeredThreads[threadId] = name;
    std::set_terminate(handleTerminate);
}
}
