#pragma once

#include <map>
#include <string>
#include <thread>

namespace twitch {

/**
 * ExceptionHandler helps register handlers for catching thread specific exceptions
 */
class ExceptionHandler {
public:
    /**
     * Register the handler for std::set_terminate
     */
    static void registerTerminateHandler(std::thread::id threadId, const std::string& name);

private:
    static std::map<std::thread::id, std::string> s_registeredThreads;
    static void handleTerminate();
};
}
