#include "FileLog.hpp"

namespace twitch {
FileLog::FileLog(const std::string& filename)
    : m_filename(filename)
    , m_level(Level::Debug)
{
    std::fstream fLog(m_filename.c_str(), std::fstream::out | std::fstream::trunc);
}

void FileLog::log(Level level, const char* format, va_list args) const
{
    // do normal logging
    PrintLog::log(level, format, args);

    std::string formattedString = getFormatted(format, args) + "\n";

    // write to a log file
    std::fstream fLog(m_filename.c_str(), std::fstream::out | std::fstream::app);
    if (fLog) {
        fLog.write(formattedString.c_str(), formattedString.length());
    }
}

void FileLog::setLevel(Level level)
{
    m_level = level;
}
}
