#include "PrefixLog.hpp"

namespace twitch {
PrefixedLog::PrefixedLog(std::shared_ptr<Log> log, const char* format, ...)
    : m_log(std::move(log))
{
    va_list args;
    va_start(args, format);
    m_prefix = PrintLog::getFormatted(format, args);
    va_end(args);
}

PrefixedLog::PrefixedLog(std::shared_ptr<Log> log, const std::string& prefix)
    : m_log(std::move(log))
    , m_prefix(prefix)
{
}

void PrefixedLog::log(Level level, const char* format, va_list args) const
{
    std::string str(format);
    m_log->log(level, (m_prefix + str).c_str(), args);
}

void PrefixedLog::setLevel(Level level)
{
    m_log->setLevel(level);
}
}
