#pragma once

#include "PrintLog.hpp"
#include <cstdarg>
#include <cstdio>

namespace twitch {
/** Log wrapper prefixing all log messages with a specific string */
class PrefixedLog : public Log {
public:
    PrefixedLog(std::shared_ptr<Log> log, const char* format, ...);
    PrefixedLog(std::shared_ptr<Log> log, const std::string& prefix);
    void log(Level level, const char* format, va_list args) const override;
    void setLevel(Level level) override;

private:
    std::shared_ptr<Log> m_log;
    std::string m_prefix;
};
}
