#include "PrintLog.hpp"
#include "platform/NativePlatform.hpp"

namespace twitch {
PrintLog::PrintLog(Log::Level level)
    : m_level(level)
{
}

void PrintLog::log(Level level, const char* format, va_list args) const
{
    if (level >= m_level) {
        std::string line = getFormatted(format, args);

        if (NativePlatform::getLogMessageHandler()) {
            NativePlatform::getLogMessageHandler()(level, line);
        } else {
            std::fprintf(stderr, "%s\n", line.c_str());
        }
    }
}

void PrintLog::setLevel(Level level)
{
    m_level = level;
}

std::string PrintLog::getFormatted(const char* format, va_list args)
{
    char buf[MaxLength] = { '\0' };
    std::vsnprintf(buf, MaxLength, format, args);
    return std::string(buf);
}
}
