#pragma once

#include "playercore/Log.hpp"
#include <cstdarg>
#include <cstdio>
#include <string>

namespace twitch {
/** Log printing to stderr */
class PrintLog : public Log {
public:
    explicit PrintLog(Log::Level level = Log::Level::Debug);
    void log(Level level, const char* format, va_list args) const override;
    void setLevel(Level level) override;

    static std::string getFormatted(const char* format, va_list args);

protected:
    static const int MaxLength = 256;

private:
    Level m_level;
};
}
