#include "ThreadGuard.hpp"
#include <cassert>

namespace twitch {
SingleThreadGuard::SingleThreadGuard()
    : m_initialized(false)
{
}

void SingleThreadGuard::validate()
{
    if (!m_initialized) {
        m_initialized = true;
        m_threadId = std::this_thread::get_id();
        return;
    }

    assert(m_threadId == std::this_thread::get_id());
}
}
