#include "TraceCall.hpp"
#include "trace.hpp"

namespace twitch {
TraceCall::TraceCall(const std::string& message, float threshold)
    : m_message(message)
    , m_threshold(threshold)
{
    if (!message.empty()) {
        TRACE_DEBUG("%s", message.c_str());
    }

    m_start = MediaTime::now();
}

TraceCall::~TraceCall()
{
    MediaTime elapsed = MediaTime::now() - m_start;

    if (elapsed.seconds() >= m_threshold) {
        TRACE_WARN("%s completed in %f seconds", m_message.empty() ? "<unknown>" : m_message.c_str(), elapsed.seconds());
    }
}
}
