#include "TraceLog.hpp"

namespace twitch {
TraceLog& TraceLog::get()
{
    static TraceLog instance;
    return instance;
}

void TraceLog::setLog(std::shared_ptr<Log> log)
{
    m_log = std::move(log);
}

void TraceLog::logf(Level level, const char* format, ...) const
{
    va_list args;
    va_start(args, format);
    log(level, format, args);
    va_end(args);
}

void TraceLog::log(Log::Level level, const char* format, va_list args) const
{
    if (m_log) {
        m_log->log(level, format, args);
    }
}

void TraceLog::setLevel(Log::Level level)
{
    if (m_log) {
        m_log->setLevel(level);
    }
}
}
