#pragma once

#include "playercore/Log.hpp"
#include <cstdarg>
#include <memory>

namespace twitch {
class TraceLog : Log {
public:
    TraceLog() = default;
    TraceLog(const TraceLog&) = delete;
    TraceLog(TraceLog&&) = delete;
    TraceLog& operator=(const TraceLog&) = delete;
    TraceLog& operator=(TraceLog&&) = delete;

    static TraceLog& get();
    void setLog(std::shared_ptr<Log> log);
    void logf(Level level, const char* format, ...) const;
    void log(Level level, const char* format, va_list args) const override;
    void setLevel(Log::Level level) override;

private:
    std::shared_ptr<Log> m_log;
};
}
