#include "debug/DebugPlayer.hpp"
#include <assert.h>

namespace twitch {
namespace debug {

void simulatePlaybackComplete(std::shared_ptr<twitch::Player> mediaPlayer)
{
    auto debugPlayer = std::static_pointer_cast<twitch::DebugMediaPlayer>(mediaPlayer);
    assert(debugPlayer);
    debugPlayer->debugSimulatePlaybackComplete();
}

void simulateVideoError(std::shared_ptr<twitch::Player> mediaPlayer)
{
    auto debugPlayer = std::static_pointer_cast<twitch::DebugMediaPlayer>(mediaPlayer);
    assert(debugPlayer);
    debugPlayer->debugSimulateVideoError();
}
}
}
