#pragma once

#include "TraceLog.hpp"
#include <cassert>
#include <cstdint>
#include <string>

#define TRACE_ERROR(...) twitch::TraceLog::get().logf(twitch::Log::Level::Error, __VA_ARGS__)
#define TRACE_WARN(...) twitch::TraceLog::get().logf(twitch::Log::Level::Warning, __VA_ARGS__)
#define TRACE_INFO(...) twitch::TraceLog::get().logf(twitch::Log::Level::Info, __VA_ARGS__)
#define TRACE_DEBUG(...) twitch::TraceLog::get().logf(twitch::Log::Level::Debug, __VA_ARGS__)

#define TRACE_WARN_ONCE(...)                \
    do {                                    \
        static bool once##__LINE__ = false; \
        if (!once##__LINE__) {              \
            TRACE_WARN(__VA_ARGS__);        \
            once##__LINE__ = true;          \
        }                                   \
    } while (0)
