#pragma once

#include "MediaReaderListener.hpp"
#include "debug/PrefixLog.hpp"
#include "media/MediaReader.hpp"
#include "player/MediaRequest.hpp"
#include "player/ScopedScheduler.hpp"
#include "player/cancellation.hpp"
#include "playercore/MediaSource.hpp"
#include "playercore/platform/Platform.hpp"
#include <memory>

namespace twitch {
/** Progressive MP4 download source */
class DownloadSource : public MediaSource, private ScopedScheduler {
public:
    DownloadSource(MediaSource::Listener& listener,
        Platform& platform, const std::shared_ptr<Scheduler>& scheduler, const std::string& url);
    ~DownloadSource() override;
    DownloadSource(const DownloadSource&) = delete;
    const DownloadSource& operator=(const DownloadSource&) = delete;

    void open() override;
    void close() override;
    void seekTo(MediaTime time) override;
    void read(const TimeRange& range) override;
    bool isLive() const override { return false; }
    bool isPassthrough() const override { return false; }
    bool isSeekable() const override { return true; }
    MediaTime getDuration() const override;
    const Quality& getQuality() const override { return m_quality; }
    void setQuality(const Quality&, bool) override {}
    const std::vector<Quality>& getQualities() const override { return m_qualities; }
    void setReadTimeout(MediaTime time) override { m_readTimeout = time; }
    void setLowLatencyEnabled(bool) override {}

private:
    void cancelRequest();
    void downloadFile();
    void onData(const uint8_t* data, size_t size, bool endOfStream);
    void onNetworkError(const std::string& message, int code);

    PrefixedLog m_log;
    MediaSource::Listener& m_listener;
    MediaReaderListener m_readerListener;
    Platform& m_platform;
    std::shared_ptr<HttpClient> m_httpClient;
    std::string m_url;
    std::unique_ptr<media::MediaReader> m_reader;
    std::vector<Quality> m_qualities;
    Quality m_quality;
    MediaTime m_readTimeout;
    MediaTime m_seekTime;
    MediaRequest m_request;
};
}
