#pragma once

#include "FileStream.hpp"
#include "MediaReaderListener.hpp"
#include "media/MediaReader.hpp"
#include "playercore/MediaSource.hpp"
#include "playercore/platform/Platform.hpp"

namespace twitch {
class FileSource : public MediaSource {
public:
    FileSource(MediaSource::Listener& listener, Platform& platform, const std::string& path);
    ~FileSource() override;
    void open() override;
    void close() override;
    void seekTo(MediaTime time) override;
    void read(const TimeRange& range) override;
    bool isLive() const override { return false; }
    bool isSeekable() const override { return true; }
    bool isPassthrough() const override { return false; }
    MediaTime getDuration() const override;
    const Quality& getQuality() const override;
    void setQuality(const Quality&, bool) override {}
    const std::vector<Quality>& getQualities() const override { return m_qualities; }
    void setReadTimeout(MediaTime) override {}
    void setLowLatencyEnabled(bool) override {}
    FileSource(const FileSource&) = delete;
    const FileSource& operator=(const FileSource&) = delete;

private:
    MediaSource::Listener& m_listener;
    MediaReaderListener m_readerListener;
    Platform& m_platform;
    std::unique_ptr<media::MediaReader> m_reader;
    std::vector<Quality> m_qualities;
    Quality m_quality;
    std::string m_path;
};
}
