#pragma once

#include "media/Stream.hpp"
#include <fstream>

namespace twitch {
class FileStream : public Stream {
public:
    explicit FileStream(const std::string& path, std::fstream::openmode mode = std::fstream::in | std::fstream::out);
    int64_t read(uint8_t* buffer, size_t size) override;
    int64_t write(const uint8_t* buffer, size_t size) override;
    int64_t length() const override;
    bool seek(size_t position) override;
    int64_t position() const override;
    bool flush() override;
    int error() const override;
    void close() override;

private:
    mutable std::fstream m_stream;
    size_t m_length;
    mutable int m_error;
};
}
