#include "MediaReaderListener.hpp"

namespace twitch {
MediaReaderListener::MediaReaderListener(MediaSource::Listener& listener)
    : m_listener(listener)
    , m_trackCount(0)
{
}

void MediaReaderListener::onMediaDurationChanged(MediaTime duration)
{
    m_listener.onSourceDurationChanged(duration);
}

void MediaReaderListener::onMediaEndOfStream()
{
    m_listener.onSourceEndOfStream();
}

void MediaReaderListener::onMediaError(const Error& error)
{
    m_listener.onSourceError(error);
}

void MediaReaderListener::onMediaFlush()
{
    m_listener.onSourceFlush();
}

void MediaReaderListener::onMediaSample(int track, const std::shared_ptr<MediaSampleBuffer>& sample)
{
    m_listener.onSourceSample(track, sample);
}

void MediaReaderListener::onMediaTrack(int track, const std::shared_ptr<MediaFormat>& format)
{
    m_trackCount++;
    m_listener.onSourceTrack(track, format);
}
}
