#pragma once

#include "media/MediaReader.hpp"
#include "playercore/MediaFormat.hpp"
#include "playercore/MediaSample.hpp"
#include "playercore/MediaSource.hpp"
#include <memory>
#include <string>

namespace twitch {
class MediaReaderListener : public media::MediaReader::Listener {
public:
    explicit MediaReaderListener(MediaSource::Listener& listener);
    void onMediaDurationChanged(MediaTime duration) override;
    void onMediaEndOfStream() override;
    void onMediaError(const Error& error) override;
    void onMediaFlush() override;
    void onMediaSample(int track, const std::shared_ptr<MediaSampleBuffer>& sample) override;
    void onMediaTrack(int track, const std::shared_ptr<MediaFormat>& format) override;

    int getTrackCount() { return m_trackCount; }

private:
    MediaSource::Listener& m_listener;
    int m_trackCount;
};
}
